# EduMetrix UK - Online Tuition Platform

A comprehensive MERN stack online tuition platform with separate sections for Admin, Teachers, and Students.

🎉 **STATUS: FULLY FUNCTIONAL** - Ready for production use!

## Features

### Admin Features
- ✅ Create and manage student profiles with country-specific syllabus options
- ✅ Create and manage teacher profiles with banking details and availability
- ✅ Trial request management (manual and website submissions)
- ✅ Class scheduling system with timezone support and recurring options
- ✅ Calendar view for classes (day/week/month)
- ✅ Finance tracking and invoice generation
- ✅ Live chat monitoring between students and teachers
- ✅ Comprehensive reporting system
- ✅ Soft delete and restore functionality for profiles

### Teacher Features
- ✅ Dashboard with today's classes and monthly statistics
- ✅ View assigned students and subjects
- ✅ Class management (start, complete, mark attendance)
- ✅ Live chat with assigned students and admin
- ✅ Monthly earnings and class reports
- ✅ Profile management

### Student Features
- ✅ Dashboard with upcoming classes and statistics
- ✅ View assigned teachers by subject
- ✅ Join classes via Google Meet links
- ✅ Live chat with teachers and admin (subject-specific)
- ✅ View homework assignments
- ✅ Invoice and payment tracking
- ✅ Attendance reports

### Technical Features
- ✅ Auto-generated login credentials (username: name@edumetrix.uk, secure password)
- ✅ JWT-based authentication with role-based access control
- ✅ Real-time chat system with Socket.io (31-day message retention)
- ✅ File upload support for profile pictures
- ✅ Timezone-aware class scheduling
- ✅ Country-specific syllabus mapping
- ✅ RESTful API architecture
- ✅ Responsive Material-UI frontend

## Tech Stack

### Backend
- **Node.js** - Runtime environment
- **Express.js** - Web framework
- **MongoDB** - Database
- **Mongoose** - ODM for MongoDB
- **Socket.io** - Real-time communication
- **JWT** - Authentication
- **Bcrypt** - Password hashing
- **Multer** - File upload handling
- **Moment-timezone** - Timezone handling

### Frontend
- **React.js** - Frontend framework
- **Material-UI** - UI component library
- **React Router** - Client-side routing
- **Axios** - HTTP client
- **Socket.io-client** - Real-time communication

## Installation & Setup

### Prerequisites
- Node.js (v14 or higher)
- MongoDB (local or cloud)
- Git

### Backend Setup

1. **Clone the repository**
   ```bash
   cd "EduMetrix UK Platform"
   ```

2. **Install backend dependencies**
   ```bash
   npm install
   ```

3. **Environment Configuration**
   ```bash
   # Update .env file with your configurations
   MONGODB_URI=mongodb://localhost:27017/edumetrix
   JWT_SECRET=your_jwt_secret_key_here
   EMAIL_USER=your_email@gmail.com
   EMAIL_PASS=your_email_password
   NODE_ENV=development
   ```

4. **Start MongoDB**
   ```bash
   # If using local MongoDB
   mongod
   ```

5. **Start the backend server**
   ```bash
   npm run server
   # or for development with nodemon
   npm run dev
   ```
   Server will run on `http://localhost:5000`

### Frontend Setup

1. **Navigate to client directory**
   ```bash
   cd client
   ```

2. **Install frontend dependencies**
   ```bash
   npm install
   ```

3. **Start the React development server**
   ```bash
   npm start
   ```
   Frontend will run on `http://localhost:3000`

### Full Development Setup

1. **Run both backend and frontend concurrently**
   ```bash
   # From root directory
   npm run dev
   ```

## Usage

### Default Admin Access
Create an admin user directly in MongoDB:
```javascript
// Connect to your MongoDB and run:
db.users.insertOne({
  username: "admin@edumetrix.uk",
  password: "$2a$10$example_hashed_password", // Hash a password
  userType: "admin",
  isActive: true,
  isDeleted: false,
  createdAt: new Date(),
  updatedAt: new Date()
});
```

### Student Profile Creation
Admin can create student profiles with:
- Student and parent information
- Country-specific syllabus options (CBSE, ICSE, IGCSE, UK Curriculum)
- Subject selection from available options
- Hourly rates in multiple currencies (USD, GBP, AED, INR)
- Google Meet links for classes

### Teacher Profile Creation
Admin can create teacher profiles with:
- Personal and contact information
- Subject expertise selection
- Salary structure (fixed monthly or hourly rate)
- Banking details for payments
- Availability schedule

### Class Scheduling
- Schedule individual or recurring classes
- Timezone-aware scheduling
- Automatic Google Meet link assignment
- Rescheduling capabilities

### Chat System
- Students can only chat with assigned teachers for specific subjects
- All users can chat with admin
- 31-day message retention policy
- Real-time messaging with Socket.io

### Finance Management
- Automatic invoice generation based on completed classes
- Monthly reports for students and teachers
- Payment tracking and status updates
- Dashboard statistics for admin

## API Endpoints

### Authentication
- `POST /api/auth/login` - User login
- `GET /api/auth/me` - Get current user profile
- `POST /api/auth/change-password` - Change password

### Admin Routes
- `POST /api/admin/students` - Create student profile
- `GET /api/admin/students` - Get all students
- `POST /api/admin/teachers` - Create teacher profile
- `GET /api/admin/teachers` - Get all teachers
- `POST /api/admin/trial-requests` - Create trial request

### Class Management
- `POST /api/classes/schedule` - Schedule classes
- `GET /api/classes/calendar` - Get calendar view
- `PUT /api/classes/:id/reschedule` - Reschedule class

### Chat System
- `POST /api/chat/start` - Start new chat
- `GET /api/chat/my-chats` - Get user's chats
- `POST /api/chat/:id/message` - Send message

### Finance
- `GET /api/finance/student-monthly-report/:id` - Student monthly report
- `POST /api/finance/generate-invoice/:id` - Generate invoice
- `GET /api/finance/invoices` - Get all invoices

## Country & Syllabus Mapping

### GCC Countries (UAE, Saudi Arabia, Qatar, Kuwait, Bahrain, Oman)
- CBSE, ICSE, IGCSE, UK Syllabus

### India
- CBSE, ICSE, IGCSE

### UK, Australia, New Zealand
- National Curriculum

## Supported Subjects
- Mathematics
- General Science
- Physics
- Chemistry
- Biology
- English
- Hindi

## Supported Classes
- Class 1 to Class 10

## Project Structure
```
├── server.js              # Main server file
├── models/                # Database models
│   ├── User.js
│   ├── Student.js
│   ├── Teacher.js
│   ├── Class.js
│   ├── Chat.js
│   └── Invoice.js
├── routes/                # API routes
│   ├── auth.js
│   ├── admin.js
│   ├── teacher.js
│   ├── student.js
│   ├── classes.js
│   ├── chat.js
│   └── finance.js
├── middleware/            # Custom middleware
│   └── auth.js
├── utils/                 # Utility functions
│   ├── passwordGenerator.js
│   └── syllabusHelper.js
├── uploads/               # File uploads directory
└── client/                # React frontend
    ├── src/
    │   ├── components/
    │   ├── pages/
    │   ├── services/
    │   └── context/
    └── public/
```

## Contributing

1. Fork the repository
2. Create a feature branch
3. Make your changes
4. Test thoroughly
5. Submit a pull request

## License

This project is proprietary software owned by EduMetrix UK.

## Support

For support or questions, please contact the development team.